//logon parameter name for proxy functionality
var ksProxyParamName = 'RUNAS';

//cache the list
var g_bProxyAccountsListComplete = false;
var g_tProxyAccountsList = null;

saw.proxy = function()
{
}

// start proxy
saw.proxy.startProxy = function(sCommand, sLogonParam, sLogonParamValue)
{
   sCommand = sCommand? sCommand : 'Dashboard';
   parent.location.href=saw.commandToURL(sCommand) + '&' + sLogonParam + '=' + saw.encodeURIComponent(sLogonParamValue);
}

// stop proxy
saw.proxy.stopProxying = function()
{
   var sReturnTo = 'dashboard'; 
   
   var tEditor = XUIPanel.getEditor('idProxyEditor');
   if (tEditor && tEditor.sProxyStartPage)
      sReturnTo = tEditor.sProxyStartPage;
   
   parent.location.href = saw.commandToURL('RevertToSelf&ReturnTo=' + sReturnTo);
}

// display the proxy dialog
saw.proxy.showProxyDialog = function(sCurrentTargetAccount, sProxyStartPage, evt)
{
   //make the dialog DIV a child of BODY
   var tDialogDiv = document.getElementById('idProxyEditorDiv');
   if (tDialogDiv.parentNode != document.body)
      document.body.appendChild(tDialogDiv);
   
   var tProxyEditor = new ProxyEditor(sCurrentTargetAccount, sProxyStartPage);
   var tDialog = new XUIDialog("idProxyEditor", tProxyEditor, null);
   tDialog.show(null, evt.clientX, evt.clientY);
   tDialog.div.style.left = evt.clientX - tDialog.div.clientWidth + "px";
}


saw.proxy.getTargetAccountsCallBack = function(tResponse)
{
   var tEditor = tResponse.getCallerObj();
   var tXml = tResponse.getXML();
   var tListNode = tXml.selectSingleNode('saw:logonParamValues');
   if (tListNode)
   {      
      g_bProxyAccountsListComplete = tListNode.getAttribute('completeList') != 'false';
      var tAccountList = tListNode.selectNodes('saw:paramValue');
      g_tProxyAccountsList = new Array(tAccountList.length);
      for (var i = 0; i < tAccountList.length; ++i)
      {
         g_tProxyAccountsList[i] = new Object;
         g_tProxyAccountsList[i].sId = tAccountList[i].getAttribute('value');
         var sDisplayName = tAccountList[i].getAttribute('text');
         if (sDisplayName)
            g_tProxyAccountsList[i].sName = g_tProxyAccountsList[i].sId + ' (' + sDisplayName + ')';
         else
            g_tProxyAccountsList[i].sName = g_tProxyAccountsList[i].sId;
      }
   }   
   else
   {  // not valid, show error message
      tEditor.showErrorMsg(XUIGetElementText(tXml.selectSingleNode('error')));      
      g_tProxyAccountsList = new Array();
      g_bProxyAccountsListComplete = true;
   }   
   
   tEditor.populateLogonParamValues(g_tProxyAccountsList);
}

saw.proxy.verifyLogonParamValueCallBack = function(tResponse)
{
   var tEditor = tResponse.getCallerObj();
   var tXml = tResponse.getXML();
   
   var tError = tXml.selectSingleNode('error');
   if (!tError)
   {
      saw.proxy.startProxy(tEditor.sProxyStartPage, tEditor.sLogonParam, tEditor.sAttemptTarget);
   }
   else
   {  // not valid, show error message
      tEditor.showErrorMsg(XUIGetElementText(tError.selectSingleNode('message')));
   }
   
}

saw.proxy.ajaxErrorCallBack = function(tResponse, aFatal)
{
   var tEditor = tResponse.getCallerObj();
   var tXml = tResponse.getXML();
   if (aFatal && aFatal[0])
      tEditor.showErrorMsg(aFatal[0].getType() + " : " + aFatal[0].getMessage());
   else
      tEditor.showErrorMsg("There was an unknown error with the server call");
}

//-----------------------------------------------------------------------------
// Proxy Editor

ProxyEditor = function(sCurrentTargetAccount, sProxyStartPage)
{
   this.sLogonParam = ksProxyParamName;
   
   this.sProxyStartPage = sProxyStartPage? sProxyStartPage : 'dashboard';

   this.sCurrentTargetAccount = sCurrentTargetAccount;
}

ProxyEditor.prototype = new XUIEditor();

ProxyEditor.prototype.load = function(xmlElement)
{
   var tErrorDiv = document.getElementById('idProxyErrorMessage');
   tErrorDiv.style.display = 'none';
   
   this.tAccountsDropdown = document.getElementById('idProxyTargetSel');
   this.tAccountInput = document.getElementById('idProxyTargetIdInput');
   
   //saw.getPreviousSiblingElement(this.tAccountsDropdown).style.display = '';
   
   //enable/disable "Stop" button
   var tStopButton = document.getElementById('idProxyStopButton');
   saw.enableMiniButton(tStopButton, this.sCurrentTargetAccount && this.sCurrentTargetAccount != 'none');

   ProxyEditor.enableOKButton(true);
   
   if (g_tProxyAccountsList)
   {
      this.populateLogonParamValues(g_tProxyAccountsList);
   }
   else
   {
      //AJAX call
      var tServerRequest = new sawr.serverRequest("GetLogonParamValues", saw.proxy.getTargetAccountsCallBack);
      tServerRequest.setCallerObj(this);
      tServerRequest.setFatalErrorHandler(saw.proxy.ajaxErrorCallBack);

      var conn = new sawr.xhrConnection(tServerRequest);
      conn.postStringData("logonParamName=" + this.sLogonParam);
      
      ProxyEditor.enableOKButton(false);
   }
}


ProxyEditor.prototype.apply = function()
{
   var sTarget = null;
   if (this.tAccountsDropdown.style.display != 'none')
   {
      if (this.tAccountsDropdown.selectedIndex >= 0)
         sTarget = this.tAccountsDropdown.options[this.tAccountsDropdown.selectedIndex].value;      
   }
   else
      sTarget = this.tAccountInput.value;
   
   if (!sTarget)
   {
      return false;
   }
   
   if (sTarget != this.sCurrentTargetAccount)
   {
      // check if the ID is valid
      if (this.tAccountsDropdown.style.display == 'none') // we bet the value picked from dropdown is value
      {
         // try to find the ID in the cached list
         for (var i = 0; i < g_tProxyAccountsList.length; ++i)
         {
            if (g_tProxyAccountsList[i].sId == sTarget)
               break;
         }
         if (i == g_tProxyAccountsList.length)
         {
            //not found, need to verify from the SAW
            this.sAttemptTarget = sTarget;
            
            //AJAX call
            var tServerRequest = new sawr.serverRequest("VerifyLogonParamValue", saw.proxy.verifyLogonParamValueCallBack);
            tServerRequest.setCallerObj(this);
            tServerRequest.setFatalErrorHandler(saw.proxy.ajaxErrorCallBack);
            var conn = new sawr.xhrConnection(tServerRequest);
            conn.postStringData('logonParamName=' + this.sLogonParam + '&paramValue=' + saw.encodeURIComponent(sTarget));
            
            return false;
         }
      }      
      
      //start proxying or switching target user
      saw.proxy.startProxy(this.sProxyStartPage, this.sLogonParam, sTarget);
   }
   
   return true;
}

ProxyEditor.prototype.populateLogonParamValues = function(tList)
{
   if (g_bProxyAccountsListComplete)
   {  
      this.tAccountsDropdown.innerHTML = "";
      var tOptions = this.tAccountsDropdown.options;
      var tNew;// = new Option('', '');
      //tOptions[tOptions.length] = tNew;
      for (var i = 0; i < tList.length; ++i)
      {
         tNew = new Option(tList[i].sName, tList[i].sId);
         tOptions[tOptions.length] = tNew;
         tNew.selected = (tList[i].sId == this.sCurrentTargetAccount);
      }
      
      this.tAccountsDropdown.style.display = '';
      this.tAccountInput.style.display = 'none';
      
      ProxyEditor.enableOKButton(tList.length > 0);
   }
   else
   {
      this.tAccountInput.value = this.sCurrentTargetAccount == 'none'? '' : this.sCurrentTargetAccount;
      
      this.tAccountsDropdown.style.display = 'none';
      this.tAccountInput.style.display = '';
      
      ProxyEditor.enableOKButton(true);
   }
   
   saw.getPreviousSiblingElement(this.tAccountsDropdown).style.display = 'none';
   
   if (this.panel.div.style.right > saw.getClientWidth())
   {
      this.panel.div.style.left = saw.getClientWidth() - 15 - this.panel.div.clientWidth + "px";
   }
}


ProxyEditor.prototype.showErrorMsg = function(sErrorMsg)
{
   var tErrorDiv = document.getElementById('idProxyErrorMessage');
   var tErrorDisplayDiv = saw.getFirstChildElement(tErrorDiv);
   if (sErrorMsg)
      tErrorDisplayDiv.innerHTML = sErrorMsg;
   else
   {
      tErrorDisplayDiv.innerHTML = saw.getNextSiblingElement(tErrorDisplayDiv).innerHTML;
   }
   
   tErrorDiv.style.display = '';
}

//disable/enable a minibutton
saw.enableMiniButton = function(tButton, bEnabled)
{
   var tAnchor = saw.getFirstChildElement(tButton);
   if (bEnabled)
   {
      tButton.className = "minibuttonOn";
      var clickFunc = tAnchor.getAttribute('clickFunc');
      if (clickFunc && tAnchor.getAttribute('onclick') == null)
         tAnchor.setAttribute('onclick', clickFunc);
      tAnchor.removeAttribute('clickFunc');   
   }
   else
   {
      tButton.className = "minibuttonOff";
      var clickFunc = tAnchor.getAttribute('onclick');
      if (clickFunc)
      {
         tAnchor.setAttribute('clickFunc', clickFunc);
         if (is_ie)   
            tAnchor.setAttribute('onclick', null);
         else
            tAnchor.removeAttribute('onclick');
      }
   }
}

//-----------------
// enable/disable the OK button of the dialog
ProxyEditor.enableOKButton = function(bEnabled)
{
   var eid = 'idProxyEditor';
   var tButton = document.getElementById(eid + 'OKButton');
   if (tButton)
   {
      saw.enableMiniButton(tButton, bEnabled);
   }
}
